@extends('layouts.app')

@section('content')



<section class="right-sidebar" id="sidebarRight">
    <div class="releases-section">
        <div class="release-sec-heading">
            <h6>Add User's DSP</h6>
        </div>

        <div class="releases-sec-main">

            @if (count($errors) > 0)
            <div class="alert alert-danger">
                <strong>Whoops!</strong> There were some problems with your input.<br><br>
                <ul>
                    @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
            @endif

            <form class="add-releses-form" method="POST" action="{{ route('userdsp.store') }}" id="frmAddUserDSP">
                @csrf

                <div class="row">

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group">
                            <label class="form-label required" for="genre">User
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Select name of the User."></i>
                            </label>
                            <select name="user_id" id="user_id" class="form-control">
                                <option value="">Select User</option>
                                @foreach($users as $user)
                                <option value="{{ $user->id }}">{{ $user->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>



                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group">
                            <label class="form-label required" for="genre">DSP
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Select name of the DSP."></i>
                            </label>
                            <select name="dsp_id" id="dsp_id" class="form-control">
                                <option value="">Select DSP</option>
                                @foreach($dsps as $dsp)
                                <option value="{{ $dsp->id }}">{{ $dsp->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group">
                            <label class="form-label required" for="genre">Countries
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Select name of the countries."></i>
                            </label>
                            <select name="country_ids[]" id="country_ids" class="form-control" multiple>
                                @foreach($countries as $country)
                                <option value="{{ $country->id }}">{{ $country->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>


                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <button type="submit" class="btn main-next-btn">Save</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>

<script type="text/javascript">
    $(document).ready(function() {
        // Initialize Bootstrap tooltips for info icons
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('.fa-circle-info'))
        var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        });

        // Validate form input
        $("#frmAddUserDSP").validate({
            rules: {
                user_id: {
                    required: true
                },
                dsp_id: {
                    required: true
                },
                "country_ids[]": {
                    required: true
                },
            },
            messages: {
                user_id: {
                    required: "User field is required"
                },
                dsp_id: {
                    required: "DSP Name field is required"
                },
                "country_ids[]": {
                    required: "Countries field is required"
                },
            }
        });
    });
</script>


@endsection